﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VeteransAffairs.Registries.BusinessAHOBPR
{
    public class BranchOfService
    {
        #region constructors
        public BranchOfService(DateTime deploymentStart, DateTime deploymentEnd, Dictionary<DateRange, string> branchesOfService)
        {
            if (branchesOfService == null) throw new ArgumentNullException(nameof(branchesOfService));
            var deploymentDateRange = new DateRange(deploymentStart, deploymentEnd);
            SetLongFormBranchOfServiceText(branchesOfService, deploymentDateRange);
        }
        private void SetLongFormBranchOfServiceText(Dictionary<DateRange, string> branchesOfService, DateRange deploymentDateRange)
        {
            //Console.WriteLine($"Branches of Service: {branchesOfService?.Count()}");
            Code = branchesOfService.Keys.Where
                            (
                            //Check if any of the DateRange keys in branchesOfService include the deployment's DateRange
                            e => e.Includes(deploymentDateRange)
                            )
                            ////There's a match? Get that branchOfService code
                            .Select(e => branchesOfService[e])
                            ////If none of the branchesOfService DateRanges are a match, insert the default (Enums.BranchOfService.Unknown is 99)
                            .DefaultIfEmpty("u")
                            //.DefaultIfEmpty("Unknown")
                            ////Take only the first, as the person should only be serving in one service at a time
                            .First();
            Id = GetStdBranchOfServiceId(Code);
            Text = GetLongFormBranchOfService(Code);

        }
        #endregion
        public string Code { get; set; }
        public string Text { get; set; }
        public int Id { get; set; }
       
        public static string GetLongFormBranchOfService(string input)
        {
            string longFormBoS = string.Empty;
            switch (input.ToLower())
            {
                case "a":
                    longFormBoS = "Army";
                    break;
                case "f":
                    longFormBoS = "Air Force";
                    break;
                case "n":
                    longFormBoS = "Navy";
                    break;
                case "m":
                    longFormBoS = "Marine Corps";
                    break;
                case "c":
                    longFormBoS = "Coast Guard";
                    break;
                case "h":
                    longFormBoS = "Public Health Service";
                    break;
                default:
                    longFormBoS = "Uknown";
                    break;
            }
            return longFormBoS;
        }

        public int GetStdBranchOfServiceId(string branchOfService)
        {
            int id = 0;

            switch (branchOfService.ToLower())
            {
                case "a":
                case "army":
                case "army nurse corps":
                    id = 1;
                    break;
                case "f":
                case "air force":
                case "airforce":
                    id = 4;
                    break;
                case "n":
                case "navy":
                    id = 2;
                    break;
                case "m":
                case "marine corps":
                case "marines":
                case "marinecorps":
                    id = 3;
                    break;
                case "c":
                case "cg":
                case "coast guard":
                case "coastguard":
                    id = 5;
                    break;
                case "h":
                case "public health service":
                    id = 6;
                    break;
                default:
                    id = 99;
                    break;
            }

            return id;
        }
        /// <summary>
        /// Get branch of service code based for a deployment based on service episdoe information.
        /// </summary>
        /// <param name="deploymentStart"></param>
        /// <param name="deploymentEnd"></param>
        /// <param name="branchesOfService"></param>
        /// <returns>branch of service code</returns>
        public static string GetBranchOfServiceCodeFromDateRange(DateTime deploymentStart, DateTime deploymentEnd, Dictionary<DateRange, string> branchesOfService)
        {
            var deploymentDateRange = new DateRange(deploymentStart, deploymentEnd);
            var epBranchOfServiceCode = branchesOfService.Keys.Where
                (
                //Check if any of the DateRange keys in branchesOfService include the deployment's DateRange
                e => e.Includes(deploymentDateRange)
                )
                //There's a match? Get that branchOfService code
                .Select(e => GetLongFormBranchOfService(branchesOfService[e]))
                //If none of the branchesOfService DateRanges are a match, insert the default (Enums.BranchOfService.Unknown is 99)
                .DefaultIfEmpty("Unknown")
                //Take only the first, as the person should only be serving in one service at a time
                .First();
            return epBranchOfServiceCode;
        }

    }


}
